// PCanIsoTpExampleDlgMessages.cpp : implementation file
//

#include "stdafx.h"
#include "PCanIsoTpExampleDlgMessages.h"
#include "PCanIsoTpExampleDlgMappings.h"
#include "afxdialogex.h"
#include "PcanIsoTpExampleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CPCanIsoTpExampleDlgMessages dialog

IMPLEMENT_DYNAMIC(CPCanIsoTpExampleDlgMessages, CDialogEx)

CPCanIsoTpExampleDlgMessages::CPCanIsoTpExampleDlgMessages(TPCANTPHandle *p_pctpHandle, CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_PCANISOTPEXAMPLE_TAB_MESSAGES, pParent),
	m_readThread(NULL),
	m_eventThread(NULL),
	m_eventHandleToReadCAN(NULL),
	m_eventHandleToStopWaitingForObject(NULL),
	m_stopReadThread(TRUE)
{
	m_pctpHandle = p_pctpHandle; // Handle selected on combobox Channel
}

void CPCanIsoTpExampleDlgMessages::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUTTON_CLEAR, buttonMsgClear);
	DDX_Control(pDX, IDC_BUTTON_FILL, buttonMsgDataFill);
	DDX_Control(pDX, IDC_BUTTON_READ, buttonMsgRead);
	DDX_Control(pDX, IDC_BUTTON_WRITE, buttonMsgWrite);
	DDX_Control(pDX, IDC_CHECK_TIMESTAMP, checkBoxMsgShowPeriod);
	DDX_Control(pDX, IDC_COMBO_MAPPING, comboBoxMsgMapping);
	DDX_Control(pDX, IDC_EDIT_DATA, textBoxMsgData);
	DDX_Control(pDX, IDC_EDIT_LENGTH, editLength);
	DDX_Control(pDX, IDC_EDIT_REMOTE, editRemote);
	DDX_Control(pDX, IDC_EDIT_SOURCE, editSource);
	DDX_Control(pDX, IDC_EDIT_TARGET, editTarget);
	DDX_Control(pDX, IDC_LIST_READ, listViewMsgs);
	DDX_Control(pDX, IDC_SPIN_REMOTE, numericUpDownRemoteAddr);
	DDX_Control(pDX, IDC_SPIN_LENGTH, numericUpDownMsgLength);
	DDX_Control(pDX, IDC_SPIN_SOURCE, numericUpDownSourceAddr);
	DDX_Control(pDX, IDC_SPIN_TARGET, numericUpDownTargetAddr);
	DDX_Control(pDX, IDC_RADIO_TIMER, radioButtonMsgTimer);
	DDX_Control(pDX, IDC_RADIO_MANUAL, radioButtonMsgManual);
	DDX_Control(pDX, IDC_RADIO_EVENT, radioButtonMsgEvent);
	DDX_Control(pDX, IDC_SPIN_PRIORITY, numericUpDownPriority);
	DDX_Control(pDX, IDC_EDIT_PRIORITY, editPriority);
	DDX_Control(pDX, IDC_CHECK_FD, checkBoxFDMessage);
	DDX_Control(pDX, IDC_CHECK_BRS, checkBoxBRS);
	DDX_Control(pDX, IDC_CHECK_HAS_PRIORITY, checkBoxHasPriority);
}


BEGIN_MESSAGE_MAP(CPCanIsoTpExampleDlgMessages, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_FILL, &CPCanIsoTpExampleDlgMessages::OnBnClickedButtonFill)
	ON_EN_UPDATE(IDC_EDIT_DATA, &CPCanIsoTpExampleDlgMessages::OnEnUpdateEditData)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_LENGTH, &CPCanIsoTpExampleDlgMessages::OnDeltaposSpinLength)
	ON_BN_CLICKED(IDC_RADIO_TIMER, &CPCanIsoTpExampleDlgMessages::OnBnClickedRadioTimer)
	ON_BN_CLICKED(IDC_RADIO_EVENT, &CPCanIsoTpExampleDlgMessages::OnBnClickedRadioEvent)
	ON_BN_CLICKED(IDC_RADIO_MANUAL, &CPCanIsoTpExampleDlgMessages::OnBnClickedRadioManual)
	ON_BN_CLICKED(IDC_BUTTON_READ, &CPCanIsoTpExampleDlgMessages::OnBnClickedButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, &CPCanIsoTpExampleDlgMessages::OnBnClickedButtonClear)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, &CPCanIsoTpExampleDlgMessages::OnBnClickedButtonWrite)
	ON_CBN_SELCHANGE(IDC_COMBO_MAPPING, &CPCanIsoTpExampleDlgMessages::OnCbnSelchangeComboMapping)
	ON_BN_CLICKED(IDC_CHECK_FD, &CPCanIsoTpExampleDlgMessages::OnBnClickedCheckFd)
	ON_BN_CLICKED(IDC_CHECK_HAS_PRIORITY, &CPCanIsoTpExampleDlgMessages::OnBnClickedCheckHasPriority)
END_MESSAGE_MAP()


// CPCanIsoTpExampleDlgMessages message handlers


/// <summary>
/// Event called when Dialog is destroyed.
/// </summary>
void CPCanIsoTpExampleDlgMessages::PostNcDestroy()
{
	TerminateReadThread();

	CleanReceivedMessagesList();

	CDialogEx::PostNcDestroy();
	delete this;
}

/// <summary>
/// Function to be called when a change occured in the configured mappings.
/// The function updates the "CPCanIsoTpExampleDlgMessages" ComboBox according to the new settings.
/// </summary>
void CPCanIsoTpExampleDlgMessages::FillComboMappings()
{
	int index;
	std::vector<MappingStatus*> m_mappings; // List of configured PCAN-ISO-TP mappings.
	m_mappings = ((CPcanIsoTpExampleDlg*)GetParent())->m_dlgMappings->m_mappings; // Get the list from parent

	comboBoxMsgMapping.ResetContent();
	// browse the list to add it to combobox
	for (UINT32 i = 0; i < m_mappings.size(); i++)
	{
		if (m_mappings[i]->SourceAddress() != L"-" && m_mappings[i]->TargetAddress() != L"-")
			index = comboBoxMsgMapping.AddString(m_mappings[i]->CanIdType() + L", " + m_mappings[i]->FormatType() + L", " + m_mappings[i]->TargetType() + L": " +
				m_mappings[i]->SourceAddress() + L" -> " + m_mappings[i]->TargetAddress());
		else
			index = comboBoxMsgMapping.AddString(m_mappings[i]->CanIdType() + L", " + m_mappings[i]->FormatType() + L", " + m_mappings[i]->TargetType());
		comboBoxMsgMapping.SetItemData(index, i);
	}
	comboBoxMsgMapping.SetCurSel(0);
	OnCbnSelchangeComboMapping();
}

/// <summary>
/// Event handler called when the button "Fill message's data" is clicked.
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnBnClickedButtonFill()
{
	CString buf = L"";
	int dataSize = numericUpDownMsgLength.GetPos32();
	// Generates a 4095-bytes String (each byte is increased by 1)
	for (int i = 1; i <= dataSize; i++)
	{
		CString byteStr = L"";
		byteStr.Format(L"%.2X", i);
		buf += byteStr;
	}
	// Sets the data according to its length
	textBoxMsgData.SetWindowTextW(buf);
}


/// <summary>
/// Event handler called when text in Edit Data field is modified.
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnEnUpdateEditData()
{
	BOOL strHasChanged = FALSE;
	CString strMessage = L"";
	textBoxMsgData.GetWindowText(strMessage);

	for (int indx = 0; indx < strMessage.GetLength(); indx++)
	{
		wchar_t nChar = strMessage[indx];

		if (((nChar >= L'0') && (nChar <= L'9')) ||
			((nChar >= L'A') && (nChar <= L'F')) ||
			((nChar >= L'a') && (nChar <= L'f')))
		{
		}
		else
		{
			strHasChanged = TRUE;
			if (indx > 0)
			{
				CString leftStr = strMessage.Left(indx);
				CString rightStr = strMessage.Right(strMessage.GetLength() - indx - 1);
				strMessage = leftStr + rightStr;
			}
			else
			{
				strMessage = strMessage.Right(strMessage.GetLength() - 1);
			}
			indx--;
		}
	}
	textBoxMsgData.SetFocus();
	if (strHasChanged == TRUE)
	{
		textBoxMsgData.SetWindowText(strMessage);
	}
	strMessage.ReleaseBuffer();
}


/// <summary>
/// Event handler called when numericUpDown of "Message's length" is changed,
/// or textBoxMsgData is left.
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnDeltaposSpinLength(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);

	CString txtData = L"";
	int dataSize = 0;
	// Gets the size of the text based on the data length.
	// Note: each byte is translated in 2 characters.
	dataSize = (pNMUpDown->iDelta + pNMUpDown->iPos) * 2;

	textBoxMsgData.SetLimitText(dataSize);
	textBoxMsgData.GetWindowTextW(txtData);

	// Adds a zero to the last "non-two-character" byte (ex. 0xF => 0x0F ; 0xFA1 => 0xFA01)
	if (txtData.GetLength() % 2 == 1)
		txtData.Insert(txtData.GetLength() - 1, L"0");
	// Modify data string based on the new length
	if (txtData.GetLength() > dataSize)
		// Data is longer than the length, truncates the string
		txtData.Truncate(dataSize);
	else
	{	// Data is shorter than the length, pads the string with zeros
		for (int i = txtData.GetLength(); i < dataSize; i++)
		{
			txtData += L"0";
		}
	}
	textBoxMsgData.SetWindowTextW(txtData);
	*pResult = 0;
}

/// <summary> 
/// Terminates "read" thread if it exists. 
/// </summary>
void CPCanIsoTpExampleDlgMessages::TerminateReadThread()
{
	// Terminates "read" thread if it exists.
	m_stopReadThread = TRUE;
	// Close stop handle thread event
	if (m_eventHandleToStopWaitingForObject != NULL)
	{
		// Set event to force close the "event thread"
		SetEvent(m_eventHandleToStopWaitingForObject);
		CloseHandle(m_eventHandleToStopWaitingForObject);
		m_eventHandleToStopWaitingForObject = NULL;
	}
	// Close thread "timer"
	if (m_readThread != NULL)
	{
		WaitForSingleObject(m_readThread, 2000);
		CloseHandle(m_readThread);
		m_readThread = NULL;
	}
	// Close handle for event
	if (m_eventHandleToReadCAN != NULL)
	{
		CloseHandle(m_eventHandleToReadCAN);
		m_eventHandleToReadCAN = NULL;
	}
	m_stopReadThread = FALSE;
}

/// <summary> 
/// Using Timer
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnBnClickedRadioTimer()
{
	// Terminates "read" thread if it exists.
	TerminateReadThread();

	if ((*m_pctpHandle != PCANTP_NONEBUS) && radioButtonMsgTimer.GetCheck()) {
		buttonMsgRead.EnableWindow(FALSE);
		m_readThread = CreateThread(NULL, NULL, (LPTHREAD_START_ROUTINE)CPCanIsoTpExampleDlgMessages::CanReadThread, (LPVOID)this->GetParent(), NULL, NULL);
	}
}

/// <summary> 
/// Using events
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnBnClickedRadioEvent()
{
	// Terminates "read" thread if it exists.
	TerminateReadThread();

	if (radioButtonMsgEvent.GetCheck()) {
		buttonMsgRead.EnableWindow(FALSE);
		m_eventHandleToReadCAN = CreateEvent(NULL, FALSE, FALSE, NULL); // Read event
		m_eventHandleToStopWaitingForObject = CreateEvent(NULL, TRUE, FALSE, NULL); // Stop thread that is waiting for CAN Read event
		m_readThread = CreateThread(NULL, NULL, (LPTHREAD_START_ROUTINE)CPCanIsoTpExampleDlgMessages::CanReadThreadForEvent, (LPVOID)this->GetParent(), NULL, NULL);
	}
}


/// <summary> 
/// Using Manual read
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnBnClickedRadioManual()
{
	// Terminates "read" thread if it exists.
	TerminateReadThread();

	if (radioButtonMsgManual.GetCheck()) {
		buttonMsgRead.EnableWindow(TRUE);
	}
}

/// <summary>
/// Loop used to read in thread or when button Read is clicked.
/// </summary>
DWORD CPCanIsoTpExampleDlgMessages::CanReadThread(LPVOID p_lpParam)
{
	// Cast lpParam argument to PCANBasicExampleDlg*
	CPcanIsoTpExampleDlg* dlgParent = (CPcanIsoTpExampleDlg*)p_lpParam;
	CPCanIsoTpExampleDlgMessages* thisDlgMessages = dlgParent->m_dlgMessages;

	// Call CPCanIsoTpExampleDlgMessages Thread member function
	do {
		Sleep(50);
		if (dlgParent->isConnected())
		{
			thisDlgMessages->readMessages();
		}
	} while (thisDlgMessages->m_stopReadThread == FALSE);

	return IDOK;
}


/// <summary>
/// Function used to configure Event to read CAN message.
/// </summary>
DWORD CPCanIsoTpExampleDlgMessages::CanReadThreadForEvent(LPVOID p_lpParam)
{
	// Cast lpParam argument to PCANBasicExampleDlg*
	CPcanIsoTpExampleDlg* dlgParent = (CPcanIsoTpExampleDlg*)p_lpParam;
	CPCanIsoTpExampleDlgMessages* thisDlgMessages = dlgParent->m_dlgMessages;
	CPcanIsoTpExampleDlg* dlgParenttest = (CPcanIsoTpExampleDlg*)thisDlgMessages->GetParent()->GetParent();
	HANDLE hEvents[2];
	hEvents[0] = thisDlgMessages->m_eventHandleToReadCAN;
	hEvents[1] = thisDlgMessages->m_eventHandleToStopWaitingForObject;
	TPCANTPStatus sts = PCANTP_ERROR_OK;

	// Sets the handle of the Receive-Event.
	sts = CANTP_SetValue(*thisDlgMessages->m_pctpHandle, PCANTP_PARAM_RECEIVE_EVENT, &thisDlgMessages->m_eventHandleToReadCAN, sizeof(thisDlgMessages->m_eventHandleToReadCAN));
	if (sts != PCANTP_ERROR_OK)
	{
		// Handles failure on the UI thread then aborts thread.
		CPCanIsoTpUtils::checkCanTpStatus(*thisDlgMessages->m_pctpHandle, sts, { PCANTP_PARAM_RECEIVE_EVENT });
		thisDlgMessages->radioButtonMsgTimer.SetCheck(true);
		return IDABORT;
	}

	DWORD dwWaitResult = -1;
	// Call CPCanIsoTpExampleDlgMessages Thread member function
	do {
		if (1) //dlgParent->isConnected()) // TODO : Utiliser isConnected !!!! et pas (1)
		{
			// Waits for Receive-Event
			dwWaitResult = WaitForMultipleObjects(2, hEvents, FALSE, INFINITE);
				// Event object was signaled
			if (dwWaitResult == WAIT_OBJECT_0)
			{
				// Process Receive-Event
				// in order to interact with the UI (calling the 
				// function readMessages)
				thisDlgMessages->readMessages();
				ResetEvent(hEvents[0]);
			}
		}
	} while ((thisDlgMessages->m_stopReadThread == FALSE) && (dwWaitResult != WAIT_OBJECT_0 + 1));

	return IDOK;
}

/// <summary>
/// Reads an ISO-TP messages from the bus CAN.
/// </summary>
/// <returns>A TPCANTPStatus error code</returns>
TPCANTPStatus CPCanIsoTpExampleDlgMessages::ReadMessage()
{
	TPCANTPMsg msg;
	TPCANTPTimestamp ts;
	TPCANTPStatus sts;

	// Reads and process a single ISO-TP message
	sts = CANTP_Read(*m_pctpHandle, &msg, &ts);
	if (sts == PCANTP_ERROR_OK)
	{
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, {}, &msg);
		ProcessMessage(msg, ts);
	}
	return sts;
}

/// <summary>
/// Reads several ISO-TP messages from the bus CAN.
/// </summary>
void CPCanIsoTpExampleDlgMessages::readMessages()
{
	TPCANTPStatus sts;
	//CPcanIsoTpExampleDlg* dlgParent = (CPcanIsoTpExampleDlg*)(this->GetParent()->GetParent());
	//CPCanIsoTpExampleDlgMessages* thisDlgMessages = dlgParent->m_dlgMessages;

	// We read at least one time the queue looking for messages.
	// If a message is found, we look again trying to find more.
	// If the queue is empty or an error occurr, we get out from
	// the dowhile statement.
	do
	{
		sts = ReadMessage();
	} while (this->m_dlgParent->isConnected() && sts == PCANTP_ERROR_OK);
}

/// <summary>
/// Processes a received message, in order to show it in the Message-ListView
/// </summary>
/// <param name="msgRcvd">The received ISO-TP message</param>
void CPCanIsoTpExampleDlgMessages::ProcessMessage(TPCANTPMsg p_msgRcvd, TPCANTPTimestamp p_ts)
{
	int i = 0;
	m_msgUpdateIndex = -1; // index of the MessageStatus in m_receiveMsgs vector to be updated 
						   // Prevent concurrent access (reading thread and UI event can alter the list)
	// Searches if the message has already been received 
	// (same Network Address Information) or if it is a new message.
	for each(MessageStatus* msg in m_receiveMsgs)
	{
		i++;
		if (msg->isSameNetAddrInfo(p_msgRcvd))
		{
			// Modifies the existing message and exits
			m_receiveMsgs[i - 1]->update(p_msgRcvd, p_ts);
			m_msgUpdateIndex = i - 1;
			break;
		}
	}
	// Message not found, it will be created
	InsertMsgEntry(p_msgRcvd, p_ts);
}

/// <summary>
/// Inserts a new entry for a new message in the Message-ListView
/// </summary>
/// <param name="msg">The messasge to be inserted</param>
/// <param name="ts">The Timesamp of the new message</param>
void CPCanIsoTpExampleDlgMessages::InsertMsgEntry(TPCANTPMsg p_msg, TPCANTPTimestamp p_ts)
{
	int index;
	MessageStatus *msgSts = NULL;
	_criticalSection.Lock();
	if (m_msgUpdateIndex == -1) {
		// The MessageStatus is a new one and doesn't exist yet, it should be added
		index = listViewMsgs.GetItemCount();
		msgSts = new MessageStatus(p_msg, p_ts, index);
		m_receiveMsgs.push_back(msgSts);
	}
	else {
		// The MessageStatus already exists (it has only been updated)
		index = m_msgUpdateIndex;
		msgSts = m_receiveMsgs[index];
		listViewMsgs.DeleteItem(index);
	}

	bool boolStateTimeStamp = (checkBoxMsgShowPeriod.GetCheck() == 1) ? TRUE : FALSE ;
	msgSts->setShowingPeriod(boolStateTimeStamp);

	// Change text color, if there is an error text is RED, else Black
	if (p_msg.RESULT != PCANTP_N_OK)
	{
		listViewMsgs.SetTextColor(RGB(255, 0, 0));
	}
	else
	{
		listViewMsgs.SetTextColor(RGB(0, 0, 0));

	}
	// Adds a corresponding new item in the message listView
	AddData(listViewMsgs, index, 0, msgSts->SourceAddress());
	AddData(listViewMsgs, index, 1, msgSts->TargetAddress());
	AddData(listViewMsgs, index, 2, msgSts->RemoteAddress());
	AddData(listViewMsgs, index, 3, msgSts->CanIdType());
	AddData(listViewMsgs, index, 4, msgSts->MsgType());
	AddData(listViewMsgs, index, 5, msgSts->FormatType());
	AddData(listViewMsgs, index, 6, msgSts->TargetType());
	AddData(listViewMsgs, index, 7, msgSts->ResultString());
	AddData(listViewMsgs, index, 8, msgSts->LengthString());
	AddData(listViewMsgs, index, 9, CPCanIsoTpUtils::IntToStr(msgSts->Count()));
	AddData(listViewMsgs, index, 10, msgSts->TimeString());
	AddData(listViewMsgs, index, 11, msgSts->DataString());
	_criticalSection.Unlock();
}

/// <summary>
/// Add rows to the CListCtrl
/// </summary>
void CPCanIsoTpExampleDlgMessages::AddData(CListCtrl &p_ctrl, int p_row, int p_col, const wchar_t *p_str)
{
	LVITEM lv;
	lv.iItem = p_row;
	lv.iSubItem = p_col;
	lv.pszText = (LPWSTR)p_str;
	lv.mask = LVIF_TEXT;
	if (p_col == 0)
		p_ctrl.InsertItem(&lv);
	else
		p_ctrl.SetItem(&lv);
}


/// <summary>
/// Event called on Init Dialog
/// </summary>
BOOL CPCanIsoTpExampleDlgMessages::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	numericUpDownSourceAddr.SetBase(16);
	numericUpDownSourceAddr.SetRange32(0, 0xFF);
	numericUpDownSourceAddr.SetPos32(0x00);

	numericUpDownTargetAddr.SetBase(16);
	numericUpDownTargetAddr.SetRange32(0, 0xFF);
	numericUpDownTargetAddr.SetPos32(0x00);

	numericUpDownRemoteAddr.SetBase(16);
	numericUpDownRemoteAddr.SetRange32(0, 0xFF);
	numericUpDownRemoteAddr.SetPos32(0x00);
	numericUpDownRemoteAddr.EnableWindow(FALSE);

	numericUpDownMsgLength.SetBase(10);
	numericUpDownMsgLength.SetRange32(0, 4095);
	numericUpDownMsgLength.SetPos32(8);

	// Set range for priority (only available in 29 bits)
	numericUpDownPriority.SetBase(10);
	numericUpDownPriority.SetRange32(0, 7);
	numericUpDownPriority.SetPos32(6);

	textBoxMsgData.SetLimitText(16);
	textBoxMsgData.SetWindowTextW(L"0000000000000000");

	// Add the column headers to the CListCtrl
	listViewMsgs.InsertColumn(0, L"Source");
	listViewMsgs.SetColumnWidth(0, 45);
	listViewMsgs.InsertColumn(1, L"Target");
	listViewMsgs.SetColumnWidth(1, 45);
	listViewMsgs.InsertColumn(2, L"Remote");
	listViewMsgs.SetColumnWidth(2, 50);
	listViewMsgs.InsertColumn(3, L"ID");
	listViewMsgs.SetColumnWidth(3, 82);
	listViewMsgs.InsertColumn(4, L"Type");
	listViewMsgs.SetColumnWidth(4, 75);
	listViewMsgs.InsertColumn(5, L"Format");
	listViewMsgs.SetColumnWidth(5, 85);
	listViewMsgs.InsertColumn(6, L"Target Type");
	listViewMsgs.SetColumnWidth(6, 75);
	listViewMsgs.InsertColumn(7, L"Result");
	listViewMsgs.SetColumnWidth(7, 50);
	listViewMsgs.InsertColumn(8, L"Length");
	listViewMsgs.SetColumnWidth(8, 45);
	listViewMsgs.InsertColumn(9, L"Count");
	listViewMsgs.SetColumnWidth(9, 45);
	listViewMsgs.InsertColumn(10, L"Timestamp");
	listViewMsgs.SetColumnWidth(10, 80);
	listViewMsgs.InsertColumn(11, L"Data");
	listViewMsgs.SetColumnWidth(11, 150);
	listViewMsgs.SendMessage(LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LVS_EX_FULLROWSELECT);

	// Sets the default reading mode : "Timer"
	checkBoxMsgShowPeriod.SetCheck(TRUE);
	radioButtonMsgTimer.SetCheck(TRUE);
	
	OnBnClickedRadioTimer();

	editRemote.EnableWindow(FALSE);
	numericUpDownRemoteAddr.EnableWindow(FALSE);

	// Get parent : CPcanIsoTpExampleDlg
	m_dlgParent = (CPcanIsoTpExampleDlg*)(this->GetParent());

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}


/// <summary>
/// Event called when Button Read is clicked
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnBnClickedButtonRead()
{
	// Reads ISO-TP messages.
	if (radioButtonMsgManual.GetCheck())
		ReadMessage();
}


/// <summary>
/// Event called when Button Clear is clicked
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnBnClickedButtonClear()
{
	TPCANTPStatus sts;

	// Clears ISO-TP Rx/Tx queues only if channel is connected.
	if (((CPcanIsoTpExampleDlg*)GetParent())->isConnected())
	{
		sts = CANTP_Reset(*m_pctpHandle);
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts);
	}
	// Clears "received messages" listview and internal list of received messages.
	_criticalSection.Lock();

	CleanReceivedMessagesList();
	listViewMsgs.DeleteAllItems();

	_criticalSection.Unlock();
}

/// <summary>
/// Event called when Button Clean Received Messages List is clicked
/// </summary>
void CPCanIsoTpExampleDlgMessages::CleanReceivedMessagesList()
{
	if (m_receiveMsgs.size() > 0)
	{
		for (UINT32 i = 0; i < m_receiveMsgs.size(); i++)
		{
			if (m_receiveMsgs[i] != NULL)
			{
				delete m_receiveMsgs[i];
				m_receiveMsgs[i] = NULL;
			}
		}
		m_receiveMsgs.clear();
	}
}

/// <summary>
/// Event called when Button Write is clicked
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnBnClickedButtonWrite()
{
	TPCANTPMsg msg;
	// List of configured PCAN-ISO-TP mappings.
	std::vector<MappingStatus*> m_mappings = ((CPcanIsoTpExampleDlg*)GetParent())->m_dlgMappings->m_mappings;
	TPCANTPStatus sts = PCANTP_N_ERROR;
	CString strByte = L"";
	int index = -1;

	// Initialization of Data field before using
	memset(msg.DATA, '\0', 4095);

	// Asserts a mapping to write is selected.
	if (comboBoxMsgMapping.GetCurSel() == CB_ERR)
		return;
	// Gets the selected mapping and asserts it is valid.
	index = comboBoxMsgMapping.GetItemData(comboBoxMsgMapping.GetCurSel());
	// Asserts if index of mapping is < 0.
	if (index < 0)
		return;
	// Asserts if corresponding mapping is NULL
	if (NULL == m_mappings[index])
		return;

	// Initializes the TPCANTPMsg to send with the selected mapping.
	msg.IDTYPE = m_mappings[index]->m_canIdType;
	msg.FORMAT = m_mappings[index]->m_formatType;
	msg.MSGTYPE = m_mappings[index]->m_msgType;
	msg.TA_TYPE = m_mappings[index]->m_targetType;

	if (m_mappings[index]->IsAutomatic())
	{
		// Be cautious with Enhanced format addressing which uses 11 bits for addresses
		if (m_mappings[index]->m_formatType != PCANTP_FORMAT_ENHANCED)
		{
			editSource.GetWindowTextW(strByte);
			msg.SA = (BYTE)CPCanIsoTpUtils::HexStrToDec(strByte);
			
			editTarget.GetWindowTextW(strByte);
			msg.TA = (BYTE)CPCanIsoTpUtils::HexStrToDec(strByte);

			editRemote.GetWindowTextW(strByte);
			msg.RA = (BYTE)CPCanIsoTpUtils::HexStrToDec(strByte);
		}
		else
		{
			// Enhanced format addressing uses 11 bits for its addresses,
			// in this case Remote address is used to store the extra bits
			// from Source and Target addresses.
			UINT32 iBuf = 0;
			// Unique SA is 11bits: store bits [7..0] in SA
			// and the rest in [7..4] of RA
			editSource.GetWindowTextW(strByte);
			iBuf = CPCanIsoTpUtils::HexStrToDec(strByte);
			msg.SA = (byte)iBuf;
			msg.RA = (byte)((iBuf >> 8) << 4);
			// Unique TA is 11bits: store bits [7..0] in TA
			// and the rest in [3..0] of RA
			editTarget.GetWindowTextW(strByte);
			iBuf = CPCanIsoTpUtils::HexStrToDec(strByte);
			msg.TA = (byte)iBuf;
			msg.RA |= (byte)(iBuf >> 8);
		}
	}
	else
	{
		// The mapping defines the addresses.
		msg.SA = m_mappings[index]->m_sourceAddr;
		msg.TA = m_mappings[index]->m_targetAddr;
		msg.RA = m_mappings[index]->m_remoteAddr;
	}
	// Initializes RESULT now to avoid a strange behaviour within Visual Studio while debugging (C++.NET issue).
	msg.RESULT = PCANTP_N_OK;
	// Sets length and data.
	editLength.GetWindowTextW(strByte); // TODO : Delete it
	msg.LEN = _wtoi(strByte); // TODO : Delete it
	int msgLength = 0; // TODO : Delete it
	msg.LEN = numericUpDownMsgLength.GetPos32();
	for (int i = 0; i < msg.LEN; i++)
	{
		if (i * 2 < textBoxMsgData.GetWindowTextLengthW() - 1) {
			textBoxMsgData.GetWindowTextW(strByte);
			strByte = strByte.Mid(i * 2, 2);
		}
		else if (i * 2 < textBoxMsgData.GetWindowTextLengthW()) {
			textBoxMsgData.GetWindowTextW(strByte);
			strByte = strByte.Mid(i * 2, 1);
		}
		else {
			strByte = L"0";
		}
		msg.DATA[i] = (BYTE)CPCanIsoTpUtils::HexStrToDec(strByte);

	}
	// CAN FD support
	if (checkBoxFDMessage.GetCheck() == 1)
	{
		msg.IDTYPE |= PCANTP_ID_CAN_FD;
		// if BRS support
		if (checkBoxBRS.GetCheck() == 1)
		{
			msg.IDTYPE |= PCANTP_ID_CAN_BRS;
		}
	}
	if (checkBoxHasPriority.GetCheck() == 1)
	{
		// Manage priority (available only in 29 bits mixed of fixed normal)
		if ((m_mappings[index]->m_formatType == PCANTP_FORMAT_FIXED_NORMAL) || (m_mappings[index]->m_formatType == PCANTP_FORMAT_MIXED) ||
			(m_mappings[index]->m_formatType == PCANTP_FORMAT_ENHANCED))
		{
			// If it is a 29bits mapping fixed normal or mixed, changing "Priority" value is allowed
			if (msg.IDTYPE & PCANTP_ID_CAN_29BIT)
			{
				msg.IDTYPE |= PCANTP_ID_CAN_IS_PRIORITY_MASK;
				// Clean old priority
				msg.IDTYPE &= PCANTP_ID_CAN_MASK + PCANTP_ID_CAN_IS_PRIORITY_MASK;
				// Add priority value
				msg.IDTYPE |= (byte)numericUpDownPriority.GetPos() << 5;
			}
		}
	}

	// Sends the message to the Tx queue of the API.
	sts = CANTP_Write(*m_pctpHandle, &msg);
	CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, {}, &msg);
}


/// <summary>
/// Event called when selection in combobox Mappings is changed
/// </summary>
void CPCanIsoTpExampleDlgMessages::OnCbnSelchangeComboMapping()
{
	// List of configured PCAN-ISO-TP mappings.
	std::vector<MappingStatus*> m_mappings = ((CPcanIsoTpExampleDlg*)GetParent())->m_dlgMappings->m_mappings;
	int index = -1;
	bool enabled;
	CString strMsgLength = L"";
	int iMsgLength = 0;
	editLength.GetWindowTextW(strMsgLength); // Get message length text
	iMsgLength = _wtoi(strMsgLength); // Get int message length text

	// Asserts a mapping is selected.
	if (comboBoxMsgMapping.GetCurSel() != CB_ERR)
	{
		// Gets the selected mapping.
		index = comboBoxMsgMapping.GetItemData(comboBoxMsgMapping.GetCurSel());
		if (index < 0)
			return;
		if (m_mappings[index] == NULL)
			return;

		// Enables the button to write the message.
		buttonMsgWrite.EnableWindow(true);
		// Source (SA), Target (TA) and Remote address (RA) textboxes are 
		// enabled ONLY if the mapping allows dynamic 
		// generation of CAN ID based on SA, TA, RA.
		// i.e. only if an "automatic mapping" is selected.
		enabled = m_mappings[index]->IsAutomatic();
		editSource.EnableWindow(enabled);
		numericUpDownSourceAddr.EnableWindow(enabled);
		editTarget.EnableWindow(enabled);
		numericUpDownTargetAddr.EnableWindow(enabled);
		// RA is also only available with Remote Diagnostic Messages.
		if (m_mappings[index]->m_msgType == PCANTP_MESSAGE_REMOTE_DIAGNOSTIC)
		{
			editRemote.EnableWindow(enabled);
			numericUpDownRemoteAddr.EnableWindow(enabled);
		}
		else
		{
			editRemote.EnableWindow(false);
			numericUpDownRemoteAddr.EnableWindow(false);
			// To avoid confusion, RA text is reset to 0x00.
			editRemote.SetWindowTextW(L"0");
		}
		// Sets SA/TA maximum values (default is 8bits, but Enhanced addressing uses 11bits for SA and TA
		numericUpDownSourceAddr.SetRange(0, (m_mappings[index]->m_formatType == PCANTP_FORMAT_ENHANCED) ? 0x7FF : 0xFF);
		numericUpDownTargetAddr.SetRange(0, (m_mappings[index]->m_formatType == PCANTP_FORMAT_ENHANCED) ? 0x7FF : 0xFF);

		// Sets SA/TA/RA as defined in the mapping.
		// If an "automatic mapping" is selected,
		// then the user has to set those value.
		if (!m_mappings[index]->IsAutomatic())
		{
			editSource.SetWindowTextW(CPCanIsoTpUtils::IntToHex(m_mappings[index]->m_sourceAddr, 2));
			editTarget.SetWindowTextW(CPCanIsoTpUtils::IntToHex(m_mappings[index]->m_targetAddr, 2));
			editRemote.SetWindowTextW(CPCanIsoTpUtils::IntToHex(m_mappings[index]->m_remoteAddr, 2));
		}
		// Sets the maximum size of the ISO-TP message.
		if (m_mappings[index]->m_targetType == PCANTP_ADDRESSING_FUNCTIONAL)
		{
			// Functional addressing allows only Single Frame to be sent
			numericUpDownMsgLength.SetRange(0, CPCanIsoTpUtils::ISOTP_MSG_FUNC_MAX_LENGTH);
			if (iMsgLength > CPCanIsoTpUtils::ISOTP_MSG_FUNC_MAX_LENGTH)
			{	// If length shown is > to max range, edit value is modified to show range max
				editLength.SetWindowTextW(L"7");
				numericUpDownMsgLength.SetPos32(CPCanIsoTpUtils::ISOTP_MSG_FUNC_MAX_LENGTH);
			}

			if (m_mappings[index]->m_formatType != PCANTP_FORMAT_NORMAL &&
				m_mappings[index]->m_formatType != PCANTP_FORMAT_FIXED_NORMAL)
			{
				numericUpDownMsgLength.SetRange(0, CPCanIsoTpUtils::ISOTP_MSG_FUNC_MAX_LENGTH - 1);
				if (iMsgLength > CPCanIsoTpUtils::ISOTP_MSG_FUNC_MAX_LENGTH - 1)
				{	// If length shown is > to max range, edit value is modified to show range max
					editLength.SetWindowTextW(L"6");
					numericUpDownMsgLength.SetPos32(CPCanIsoTpUtils::ISOTP_MSG_FUNC_MAX_LENGTH - 1);
				}
			}
		}
		else
		{
			numericUpDownMsgLength.SetRange(0, CPCanIsoTpUtils::ISOTP_MSG_PHYS_MAX_LENGTH);
			if (iMsgLength > CPCanIsoTpUtils::ISOTP_MSG_PHYS_MAX_LENGTH)
			{	// If length shown is > to max range, edit value is modified to show range max
				editLength.SetWindowTextW(L"4095");
				numericUpDownMsgLength.SetPos32(CPCanIsoTpUtils::ISOTP_MSG_PHYS_MAX_LENGTH);
			}
		}

		if ( ((m_mappings[index]->m_formatType == PCANTP_FORMAT_FIXED_NORMAL) || (m_mappings[index]->m_formatType == PCANTP_FORMAT_MIXED) ||
			(m_mappings[index]->m_formatType == PCANTP_FORMAT_ENHANCED)) && m_mappings[index]->m_canIdType == PCANTP_ID_CAN_29BIT)
		{
			// If it is a 29bits mapping fixed normal, enhanced or mixed, changing "Priority" value is allowed
			checkBoxHasPriority.EnableWindow(true);
		}
		else
		{
			// If it is a 29bits mapping fixed normal or mixed, changing "Priority" value is allowed
			checkBoxHasPriority.EnableWindow(false);
			checkBoxHasPriority.SetCheck(0);
			numericUpDownPriority.EnableWindow(false);
			editPriority.EnableWindow(false);
		}
	}
	// No mapping is selected in comboBox.
	else
	{
		// Disables "write message" UI components.
		enabled = false;
		buttonMsgWrite.EnableWindow(enabled);
		editSource.EnableWindow(enabled);
		editTarget.EnableWindow(enabled);
		editRemote.EnableWindow(enabled);
		editPriority.EnableWindow(enabled);
		checkBoxHasPriority.EnableWindow(enabled);
		numericUpDownPriority.EnableWindow(enabled);
		checkBoxBRS.EnableWindow(enabled);
		checkBoxFDMessage.EnableWindow(enabled);
	}
}


void CPCanIsoTpExampleDlgMessages::ManageUIForFD(bool p_state)
{
	checkBoxBRS.ShowWindow(p_state);
	checkBoxFDMessage.ShowWindow(p_state);
	checkBoxBRS.EnableWindow(!p_state);
	checkBoxFDMessage.EnableWindow(p_state);
}

void CPCanIsoTpExampleDlgMessages::OnBnClickedCheckFd()
{
	checkBoxBRS.EnableWindow(checkBoxFDMessage.GetCheck() == 1);
}


void CPCanIsoTpExampleDlgMessages::OnBnClickedCheckHasPriority()
{
	editPriority.EnableWindow(checkBoxHasPriority.GetCheck() == 1);
	numericUpDownPriority.EnableWindow(checkBoxHasPriority.GetCheck() == 1);
}
